﻿<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja INF-2</title>
		<script runat="server">

	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context): base(context) {
			rok = PrevYear();
		}
		
		int rok;
		[Required]
		[Caption("Raport za")]
		public int Rok {
			get { return rok; }
			set {
				if (value==0)
					value = PrevYear(); 
				rok = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		int PrevYear() {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data==Date.Empty)
				data = Date.Today;
			return data.Year-1;
		}
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	}

    Dictionary<object, object[]> dict = new Dictionary<object, object[]>();
    List<object> oddzialy = new List<object>();
    string title;

	void OnContextLoad(Object sender, EventArgs args) {
		ReportHeader1["ROK"] = pars.Rok.ToString();
        title = ReportHeader1.Title;

		KadryModule kadry = KadryModule.GetInstance(dc);
		for (int i=0; i<12; i++) {		
			YearMonth ym = new YearMonth(pars.Rok, i+1);
            ZPCHR zpchr = new ZPCHR(true, ym, ZPCHR.WarunkiNaliczania.PFRON);
            Soneta.Business.View view = kadry.Pracownicy.GetNaEtatach(ym.ToFromTo());

            List<Pracownik> list;
            Dictionary<object, List<Pracownik>> dict2 = new Dictionary<object, List<Pracownik>>();
            if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
                Date data = ym.FirstDay;
                foreach (Pracownik pracownik in view) {
                    PracHistoria ph = pracownik[data];
                    OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                    while (of != null) {
			            if (of.GetObjectRight() != AccessRights.Denied &&
                            of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                            break;
                        of = of.Nadrzedny;
                    }
                    if (of == null)
                        continue;
                    if (!dict2.TryGetValue(of, out list))
                        dict2.Add(of, list = new List<Pracownik>());
                    list.Add(pracownik);
                }
            }
            else {
                dict2.Add(string.Empty, list = new List<Pracownik>());
                foreach (Pracownik pracownik in view)
                    list.Add(pracownik);
            }

		    object[] src;
            foreach (object of in dict2.Keys) {
                if (!dict.TryGetValue(of, out src))
                    dict.Add(of, src = new object[12]);
			    src[i] = zpchr.Razem(dict2[of]);
            }
		}

        oddzialy.AddRange(dict.Keys);
        DataRepeater1.DataSource = oddzialy;
    }
	
	void OnBeforeRow(Object sender, EventArgs args) {
        object of = DataRepeater1.CurrentRow;
        if (of is OddzialFirmy)
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "Oddział: " + of);
        else
            ReportHeader1.Title = title.Replace("%ODDZIAL%", "");

		Grid1.DataSource = dict[of];
    }

	void Grid1_BeforeRow(object sender, RowEventArgs arg) {
		ZPCHR.MiesiącInfo info = (ZPCHR.MiesiącInfo)arg.Row;
		decimal e = info.Etaty;
		decimal n = info.EtatyNiepełnosprawni;
		if (e!=0m)
			colWzon.EditValue = new Percent(n/e);
	}
	
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaINF2" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
			    <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA DLA DEKLARACJI INF-2|</strong>Raport za rok: <strong>%ROK%|Wydruk jest raportem historycznym!|%ODDZIAL%"
				    runat="server"></cc1:reportheader>
			    <ea:grid id="Grid1" runat="server" onbeforerow="Grid1_BeforeRow">
				    <Columns>
					    <ea:GridColumn Align="Center" DataMember="Miesiąc.Month" Caption="|Miesiąc||(1)" Format="{0:00}"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Pracownicy" Caption="Zatrudnienie w osobach~Pracownicy og&#243;łem|(2)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Lekki" Caption="Zatrudnienie w osobach~|Lekki|(3)" HideZero="True"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="Umiarkowany" Caption="Zatrudnienie w osobach~|Umiarkowany|(4)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Znaczny" Caption="Zatrudnienie w osobach~|Znaczny|(5)"
						    HideZero="True"></ea:GridColumn>
					    <ea:GridColumn RightBorder="Double" Align="Right" DataMember="Etaty" Caption="Zatrudnienie w przeliczeniuna pełne etaty~Pracownicy og&#243;łem|(6)"
						    HideZero="True" Format="{0:n}" ID="eo"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyLekki" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Lekki|(7)"
						    HideZero="True" Format="{0:n}" ID="el"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyUmiarkowany" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Umiarkowany|(8)"
						    HideZero="True" Format="{0:n}" ID="eu"></ea:GridColumn>
					    <ea:GridColumn Align="Right" DataMember="EtatyZnaczny" Caption="Zatrudnienie w przeliczeniuna pełne etaty~|Znaczny|(9)"
						    HideZero="True" Format="{0:n}" ID="ez"></ea:GridColumn>
					    <ea:GridColumn Align="Right" Caption="|WZON||(10)" ID="colWzon"></ea:GridColumn>
				    </Columns>
			    </ea:grid>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
